# Crestron eControl CIP Intersystem Communication

## Port: 41794

## Proto: UDP (and SSL UDP)

## Amplification factor: ~15x

## Reflector count: ~5,500 (60% reduction in 3 months, well done)

---

Crestron 3-Series Control System suffers from default misconfiguration of allowing version and hostname information to be transmitted via the internet over unauthenticated UDP.

### Example Request / Response

- Request: 1 control code byte

  - > ~# echo -ne '\x14'|nc -u 73.85.174.247 41794 -w1|xxd -p|wc -c

- Response: 394 bytes (80% of data consists of null byte padding)

  - ASCII: `�DIN-AP-7F74F65FDIN-AP3 [v1.503.3318.26859 (Feb 01 2018), #00D93D96] @E-00107f74f65f`
  - Raw Hex Bytes: `1500000001840001000044494e2d41502d37463734463635460000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000044494e2d415033205b76312e3530332e333331382e323638353920284665622030312032303138292c202330304439334439365d2040452d303031303766373466363566000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000`

### Documentation

- https://www.crestron.com/Products/Control-Hardware-Software/Hardware/Control-Systems/MC3

### Mitigations

- Stop allowing default Internet access, restrict to LAN as default configuration (vendor issue)!
- Similar to other industrial control systems and household automation security issues.
- Response data is ALWAYS 394 bytes and consists of first-data-byte control character `\x15` with over 80% of the data in `\x00` byte padding:
  - 15000000018400040000(hostname)000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(versioning)00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
